# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Database
    class BaseMysql < Base
      def initialize(name,mode=:sync)
        super(name,mode,:mysql)
        name_s=name.to_s
        config.declare_dynamic_key(:"db.#{name_s}.server",:string,nil,false)
        config.declare_dynamic_key(:"db.#{name_s}.port",:uint,3306,false)
        config.declare_dynamic_key(:"db.#{name_s}.socket",:string,nil,false)
        config.declare_dynamic_key(:"db.#{name_s}.database",:string)
        config.declare_dynamic_key(:"db.#{name_s}.auth",:string)

        @server=config[:"db.#{name_s}.server"]
        @server=nil if @server==''
        @port=config[:"db.#{name_s}.port"]
        @port=nil if @port==0 || @server.nil?()
        @port=3306 if @port.nil?() && !@server.nil?()
        @socket=config[:"db.#{name_s}.socket"]
        @socket=nil if @socket==''
        @database=config[:"db.#{name_s}.database"]
        @auth_name=config[:"db.#{name_s}.auth"]
        @max_query_length=nil
        @auth=Ghun::Auth::Item.new(@auth_name)
        if @auth.supports_username?()
          @user=@auth.username
          @password=nil
          @password=@auth.password if @auth.supports_password?()
          @password=nil if @password==''
        else
          raise MysqlConnectionError, "No username given for mysql connection #{name_s}"
        end
        raise MysqlConnectionError, "No database given for mysql connection #{name_s}" if @database.nil?() || @database==''
        raise MysqlConnectionError, "Neither server address nor socket given" if @server.nil?() && @socket.nil?()
        unless @server.nil?() || @socket.nil?()
          warn "Server address and socket given for mysql connection #{name_s}; using  socket"
          @server=nil
        end
      end

      def compose_and_query(head,tails,qualified_keys=false)
        determine_query_length if @max_query_length.nil?()
        queries=Array.new()
        first_query=true
        values=""
        separator=(head.nil?())?(';'):(',')
        head="" if head.nil?()
        tails.each do |t|
          len=head.length() + values.length() + separator.length() + t.length()
          if len < @max_query_length then
            if first_query then
              values+="#{t}"
              first_query=false
            else
              values+="#{separator}#{t}"
            end
          else
            queries << (head+values)
            first_query=false
            values="#{t}"
          end
        end
        queries << (head+values) unless values==""
        query(queries,qualified_keys)
      end

      def compose_where_between_and_query(head,field,values,no_harm_values=[],qualified_keys=false)
        determine_query_length if @max_query_length.nil?()
        queries=Array.new()
        v=values
        v.sort!
        v.uniq!
        v_no_harm=no_harm_values
        v_no_harm.sort!
        v_no_harm.uniq!
        min=-1
        max=-1
        v.each do |id|
          if max==-1 then
            min=id
            max=id
          elsif max+1==id  || (max+1 < id && v_no_harm.include?(id)) then
            max=id
          elsif max+1 < id then
            queries << "#{head} WHERE `#{Ghun::Database::Mysql.escape_string(field)}` BETWEEN #{min.to_s} AND #{max.to_s}"
            min=id
            max=id
          end
        end
        queries << "#{head} WHERE `#{Ghun::Database::Mysql.escape_string(field)}` BETWEEN #{min.to_s} AND #{max.to_s}" unless max==-1
        query(queries,qualified_keys)
      end

      def compose_where_in_and_query(head,field,values,qualified_keys=false)
        determine_query_length if @max_query_length.nil?()
        queries=Array.new()
        v=values
        v.sort!
        v.uniq!
        in_values=""
        v.each do |id|
          len="#{head} WHERE `#{Ghun::Database::Mysql.escape_string(field)}` IN (#{values},#{id.to_s})".length()
          if len < @max_query_length then
            in_values+="," unless in_values==""
            in_values+="#{id}"
          else
            queries << ("#{head} WHERE `#{Ghun::Database::Mysql.escape_string(field)}` IN (#{values})")
            values="#{id}"
          end
        end
        queries << ("#{head} WHERE `#{Ghun::Database::Mysql.escape_string(field)}` IN (#{values})") unless in_values==""
        query(queries,qualified_keys)
      end

      def query(query,qualified_keys=false)
        if query.is_a?(Array)
          queries=Array.new()
          query.each do |q|
            queries << {:query => q, :qualified_keys => qualified_keys}
          end
          return execute_request(queries)
        elsif query.match(';')
          queries=Array.new()
          query.split(';').each do |q|
            next if q.nil?() || q.strip().empty?()
            queries << {:query => q, :qualified_keys => qualified_keys}
          end
          return execute_request(queries)
        else
          return execute_request({:query => query, :qualified_keys => qualified_keys})
        end
      end

      def enqueue_query(id,query,qualified_keys=false)
        enqueue_request(id,{:query => query, :qualified_keys => qualified_keys})
      end

    private

      def determine_query_length()
        db=query("SHOW VARIABLES LIKE 'max_allowed_packet'")
        begin
          @max_query_length=Integer(db[:"1"][:"Value"])
        rescue => e
          error "Could not determine max query length", e
          @max_query_length=1048576
        end
      end
    end
  end
end

if Ghun::Base::Blackboard.ruby_engine==:jruby
  Ghun::Base.relative_require_if_exists(__FILE__, "mysql.inc.java.rb")
else
  Ghun::Base.relative_require_if_exists(__FILE__, "mysql.inc.ruby.rb")
end
