# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
begin
  require 'mysql'

  module Ghun
    module Database
      class Mysql < BaseMysql
        Ghun::Database::Handler::ENGINE_SELECTOR.register_member(self,:mysql)
        def initialize(name,mode=:sync)
          super(name,mode)
        end

        def connected?()
          !@db.nil?() && @db.ping()
        rescue
          return false
        end

        def self.escape_string(string)
          ::Mysql.escape_string(string)
        end

      private

        def execute_helper(args)
          debug args[:query]
          raw=@db.real_query(args[:query])
          affected_rows=@db.affected_rows
          result=nil
          unless raw.nil? then
            result=Hash.new()
            for i in 1..raw.num_rows
              raw_row=raw.fetch_hash(args[:qualified_keys])
              row=Hash.new()
              raw_row.each do |key,value|
                row[key.intern]=value
              end
              result[i.to_s.intern]=row
            end
          end
          debug "#{affected_rows} affected rows"
          debug "Got result: #{result.to_s}" unless result.nil?
          debug "empty result" if result.nil?
          return result
        end

        def connect_helper()
          if @db.nil?()
            @db=::Mysql.new(@server,@user,@password,@database,@port,@socket,nil)
            @db.set_server_option(::Mysql::OPTION_MULTI_STATEMENTS_ON)
            return true
          else
            @db.close()
            @db.connect(@server,@user,@password,@database,@port,@socket,nil)
            @db.set_server_option(::Mysql::OPTION_MULTI_STATEMENTS_ON)
            return true
          end
        rescue => e
          error "Failed to create database connection with name #{@name}", e
          return false
        end

        def disconnect_helper()
          @max_query_length=nil
          @db.close()
          return true
        rescue => e
          error "Failed to close database connection with name #{@name}", e
          return false
        end
      end
    end
  end
rescue LoadError => e
  Ghun::Base::Blackboard.logger.warn(Ghun::Log::Message.new(Ghun::Log::Level::WARN,Ghun::Log::Source::DATABASE, Ghun::Log::Type::BASE, "Failed to load needed file, no support for MySQL databases: #{e.message}"))
end
