# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
Ghun::Base.java_require("dnsjava")
module Ghun
  module Dns
    class Resolver < Ghun::Dns::BaseResolver
      def initialize()
        super()
      end

    private

      def init_config
        super()
        @resolver=::Dns::SimpleResolver.new(@server)
        @resolver.set_tcp(@force_tcp)
      end

      def format_result(result)
        if result.empty? then
          debug "Got emtpy result"
          return []
        else
          debug "Got result #{result.to_s}"
          formatted=Array.new()
          result.each do |rr|
            begin
              address=nil
              needs_lookup=false
              case rr.class.to_s
              when ::Dns::NSRecord.to_s
                address=rr.get_target.to_s.gsub(/^\//,'')
                type="NS"
                needs_lookup=true
              when ::Dns::CNAMERecord.to_s
                address=rr.get_alias.to_s.gsub(/^\//,'')
                type="CNAME"
                needs_lookup=true
              when ::Dns::ARecord.to_s
                address=rr.get_address.to_s.gsub(/^\//,'')
                type="A"
              when ::Dns::AAAARecord.to_s
                address=rr.get_address.to_s.gsub(/^\//,'')
                type="AAAA"
              when ::Dns::PTRRecord.to_s
                address=rr.get_address.to_s.gsub(/^\//,'')
                type="PTR"
              else
                debug "Ignoring entry #{rr.to_s} with class #{rr.class}"
              end
              formatted << ResultEntry.new(type,rr.get_name.to_s.sub(/\.$/,''),address,needs_lookup) unless address.nil?
            rescue => e
              error "Invalid entry #{rr.to_s}", e
            end
          end
          return formatted
        end
      end

      def execute_helper(args)
        result=nil
        case args[:type]
        when :A, :AAAA
          l=::Dns::Lookup.new(args[:argument],::Dns::Type.const_get(args[:type]))
          l.set_resolver(@resolver)
          l.run()
          if l.get_result==::Dns::Lookup::SUCCESSFUL then
            debug "Successful query for #{args[:argument]} with type #{args[:type]}"
            result=l.get_answers.to_ary
          else
            warn "Query for #{args[:argument]} with type #{args[:type]} failed"
          end
        when :AXFR
          debug "name: #{args[:argument]} type: AXFR"
          axfr=::Dns::ZoneTransferIn.newAXFR(::Dns::Name.new(args[:argument]),@server,nil)
          axfr.run()
          result=axfr.get_axfr.toArray.to_ary
        when :PTR
          query = ::Dns::Message.newQuery(::Dns::Record.newRecord(::Dns::ReverseMap.from_address(args[:argument]),::Dns::Type::PTR,::Dns::DClass::IN))
          response=@resolver.send(query)
          result=response.getSectionArray(::Dns::Section::ANSWER).to_ary
        end
        return result
      end
    end
  end
end
