# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Dns
    class BaseResolver < Ghun::Base::StatelessConnection
      Ghun::Base::Blackboard.config.declare_key(:"dns.force_tcp",:bool,false)
      Ghun::Base::Blackboard.config.declare_key(:"dns.allow_caching",:bool,true)
      Ghun::Base::Blackboard.config.declare_key(:"dns.server",:string)

      Ghun::Base::Blackboard.config.declare_key(:"connection.dns.execute_retries", :uint, 2, true)
      Ghun::Base::Blackboard.config.declare_key(:"connection.dns.execute_retry_wait", :uint, 10, true)
      Ghun::Base::Blackboard.config.declare_key(:"connection.dns.execute_retry_wait_first_time", :uint, 5, true)

      def initialize()
        super(:sync,:dns,Ghun::Log::Source::DNS)
        init_config
      end

      def reload_config
        init_config
      end

      def lookup_reverse(address)
        format_result(base_query(address,:PTR))
      rescue => e
        error "Reverse lookup for #{address} failed", e
        return nil
      end

      def lookup(name)
        result=Array.new()
        ipv4=format_result(lookup_ipv4(name))
        ipv6=format_result(lookup_ipv6(name))
        result.concat(ipv4) unless ipv4.nil?()
        result.concat(ipv6) unless ipv6.nil?()
        return result
      rescue => e
        error "Lookup for #{name} failed", e
        return []
      end

      def lookup_ipv4(name)
        format_result(base_query(name,:A))
      rescue => e
        error "IPv4 lookup for #{name} failed", e
        return nil
      end

      def lookup_ipv6(name)
        format_result(base_query(name,:AAAA))
      rescue => e
        error "IPv6 lookup for #{name} failed", e
        return nil
      end

      def zone_transfer(zone)
        format_result(base_query(zone,:AXFR))
      rescue => e
        error "Zone transfer for zone #{zone} failed", e
        return nil
      end

    private

      def init_config
        @force_tcp=config[:"dns.force_tcp"]
        @allow_caching=config[:"dns.allow_caching"]
        @server=config[:"dns.server"]
      end

      def base_query(argument,type)
        execute_helper({:argument => argument, :type => type})
      end

      def format_result(result)
        raise Ghun::Base::AbstractClassError, "Implement format_result to use #{self.class}"
      end

      def execute_helper(args)
        raise Ghun::Base::AbstractClassError, "Implement execute_helper to use #{self.class}"
      end
    end
  end
end

if Ghun::Base::Blackboard.ruby_engine==:jruby
  Ghun::Base.relative_require_if_exists(__FILE__, "resolver.inc.java.rb")
else
  Ghun::Base.relative_require_if_exists(__FILE__, "resolver.inc.ruby.rb")
end
