# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
require 'dnsruby'
module Ghun
  module Dns
    class Resolver < Ghun::Dns::BaseResolver
      def initialize()
        super()
        @logger_compatible=Log::CompatibleLogger.new(self,Log::Source::DNS,Log::Type::EXTERNAL_LIBS)
        Dnsruby.instance_variable_set "@logger",@logger_compatible
      end

    private

      def init_config()
        super()
        @resolver=Dnsruby::Resolver.new
        @resolver.set_config_nameserver(@server)
        @resolver.use_tcp=@force_tcp
        @resolver.do_caching=@allow_caching
      end

      def format_result(result)
        if result.nil?() || result.empty?() then
          debug "Got emtpy result"
          return []
        else
          debug "Got result #{result.to_s}"
          formatted=Array.new()
          result.each do |rr|
            begin
              address=nil
              needs_lookup=false
              result_name=nil
              case rr.class.to_s
              when "Dnsruby::RR::IN::NS"
                address=rr.nsdname.to_s
                result_name=rr.name.to_s
                needs_lookup=true
              when "Dnsruby::RR::IN::A"
                address=rr.address.to_s
                result_name=rr.name.to_s
                needs_lookup=false
              when "Dnsruby::RR::IN::AAAA"
                address=rr.address.to_s
                result_name=rr.name.to_s
                needs_lookup=false
              when "Dnsruby::RR::IN::CNAME"
                address=rr.cname.to_s
                result_name=rr.name.to_s
                needs_lookup=true
              when "Dnsruby::RR::IN::PTR"
                #XXX needs testing
                address="XXX"
                result_name=rr.domainname.to_s
                needs_lookup=false
              else
                debug "Ignoring entry #{rr.to_s} with class #{rr.class}"
              end
              formatted << ResultEntry.new(rr.type.to_s,result_name,address,needs_lookup) unless address.nil?
            rescue => e
              error "Invalid entry #{rr.to_s}", e
            end
          end
          return formatted
        end
      end

      def execute_helper(args)
        debug Log::Type::QUERY, "name: #{args[:argument]} type: #{args[:type]}"
        if args[:type]==:AXFR then
          axfr = Dnsruby::ZoneTransfer.new
          axfr.transfer_type = Dnsruby::Types.AXFR
          axfr.server = @server
          return axfr.transfer(args[:argument])
        else
          return @resolver.query(args[:argument],args[:type].to_s).answer
        end
      end
    end
  end
end
