# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Output
    DISTRIBUTED_HANDLER=Ghun::Base::SimpleHandler.new(Ghun::Log::Source::OUTPUT)
    #FIXME improve performance for @immediate_write and @version_immediate_writes
    # current implementation has to be considered as inherently broken for IO use cases
    # @immediate_write should append lines to the existing file, maybe while keeping it open and using flush
    # @version_immediate_writes should copy the current state instead of writing
    class Distributed < Ghun::Base::Module
      def initialize(name,file,versioned=true,immediate_write=false,version_immediate_writes=false,base=nil)
        super(Ghun::Log::Source::OUTPUT)
        @headline=nil
        @data=Array.new()
        @mode=nil
        @versioned=versioned
        @immediate_write=immediate_write
        @version_immediate_writes=version_immediate_writes
        @mutex=Monitor.new()
        @output=nil
        if file.is_a?(Array)
          @file=file
          @file << file if file.size() <=1
          @file << file if file.size() <=1
        else
          @file=[file,file]
        end
        if @versioned
          @output=Versioned.new(nil,nil,nil,true,base)
        else
          @output=Base.new(base)
        end
        @immediate_counter=0
        @immediate_timestamp=nil
        @immediate_timestamp=TimeStamp.new('by_epoch',true) if @version_immediate_writes
        DISTRIBUTED_HANDLER.register_member(name.intern,self)
      end

      def headline=(headline)
        @mutex.synchronize {
          if !@headline
            mode=headline.class.to_s.downcase.intern
            if mode!=:string && mode!=:array && mode!=:hash
              warn "Mode #{@mode} is not supported; skipping"
            else
              @headline=headline
              @mode=mode
              write_data() if @immediate_write
            end
          elsif @headline && @headline.class==headline.class
            debug "Overwriting headline '#{@headline}' with '#{headline}'"
          else
            warn "Headline #{headline} would change mode from #{@mode} to #{headline.class.to_s.downcase.intern}; skipping"
          end
        }
      end

      def reset_data()
        @muetx.synchronize {
          @data=Array.new()
        }
      end

      def append_data(data,no_encoded_output=true)
        @mutex.synchronize {
          if data.is_a?(Array) && !data.empty?() && data[0].is_a?(Array)
            data.each do |d|
              append_data(d)
            end
          else
            mode=data.class.to_s.downcase.intern
            if @mode && @mode==mode
              debug "Appending #{data} "
              @data << data
              write_data(no_encoded_output) if @immediate_write
            elsif @mode && @mode!=mode
              warn "Mode mismatch between #{@mode} and #{mode}; skipping"
            elsif mode==:string || mode==:array || mode!=:hash
              @data << data
              @mode=mode
              write_data(no_encoded_output) if @immediate_write
            else
              warn "Mode #{@mode} is not supported; skipping"
            end
          end
        }
      end

      def write_data(no_encoded_output=true)
        @mutex.synchronize {
          data=@data
          opts=Hash.new()
          opts[:no_encoded_output]=no_encoded_output
          case @mode
          when :string
            opts={:readable_array => true}
            data=[@headline]+@data
          when :array
            opts={:array_headline => @headline, :array_array_as_csv => true}
            data=@data
          when :hash
            opts={:hash_headline => @headline, :hash_array_as_csv => true}
            data=@data
          end
          if data.empty?() && @output.avoid_empty_files()
            debug "Not writing headline-only content for #{@file}"
          else
            if @version_immediate_writes
              f=@file.clone()
              f[-1]="#{@immediate_timestamp.default()}_#{"%06d" % @immediate_counter}_#{@file[-1]}"
              @immediate_counter+=1
              @output.store(data,f,opts)
            end
            @output.store(data,@file,opts)
          end
        }
      end
    end
  end
end
