# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Output
    class TimeStamp
      Ghun::Base::Blackboard.config.declare_key("output.default_timestamp_format", :string, "by_date_by_time")
      def initialize(default_format=nil,update_every_time=false)
        @update_every_time=update_every_time
        @default_format=default_format
        @special=false
        @default_format=Ghun::Base::Blackboard.config[:"output.default_timestamp_format"] unless @default_format
        update_timestamp()
      end
      attr_writer :update_every_time
      attr_writer :time
      attr_accessor :default_format
      attr_accessor :special

      def update_every_time?()
        @update_every_time
      end

      def update_timestamp()
        @time=Time.now()
      end

      def default(output_format=:string)
        self.send("get_#{output_format.to_s}_#{@default_format}".intern)
      end

      def method_missing(method,*args)
        update_timestamp if update_every_time?()
        result=Array.new()
        strft={
          :year => "%Y",
          :month => "%m",
          :day => "%d",
          :date => "%Y%m%d",
          :hour => "%H",
          :minute => "%M",
          :second => "%S",
          :time => "%H%M%S",
          :mysql => "%Y-%m-%d %H:%M:%S",
          :epoch => "%s",
          :dash => "-",
          :underscoce => "_",
          :colon => ":",
          :space => " ",
        }
        parts=method.to_s.split('_')
        type=parts.shift
        if parts[0]!="by"
          format=parts.shift
        elsif !(args.nil?() || args.empty?())
          format=args[0]
        else
          format=:string
        end
        format=format.intern unless format.nil?()
        type=type.intern unless type.nil?()
        raise NoMethodError, "undefined method #{method.to_s} for #{self.to_s}:#{self.class}" unless type==:get
        raise FormatError, "Unfined output format #{format.to_s} in #{method.to_s} of #{self.to_s}:#{self.class}" unless format==:string || format==:array || format==:dir

        component=nil
        parts.each do |part|
          if part=="by" && component.nil?()
            component=""
          elsif part=="by"
            result << @time.strftime(component) unless component.empty?()
            component=""
          else
            component+=strft[part.intern] if strft.include?(part.intern)
          end
        end
        result << @time.strftime(component) unless component.nil?() || component.empty?()
        if format==:array
          return result
        elsif format==:string
          return result.join("_")
        elsif format==:dir
          return File.join(result)
        end
        return ""
      end

      class << self
        def create_global_timestamp(name)
          @timestamps=Hash.new() unless defined?(@timestamps) && !@timestamps.nil?()
          @timestamps[name.intern]=TimeStamp.new() unless @timestamps.include?(name.intern)
          return @timestamps[name.intern]
        end

        def delete_global_timetamp(name)
          @timestamps=Hash.new() unless defined?(@timestamps) && !@timestamps.nil?()
          @timestamps.delete[name.intern] if @timestamps.include?(name.intern)
          return nil

        end

        def update_global_timestamp(name)
          @timestamps=Hash.new() unless defined?(@timestamps) && !@timestamps.nil?()
          @timestamps[name.intern].update_timestamp() if @timestamps.include?(name.intern)
          return @timestamps[name.intern]
        end

        def get_global_timestamp(name)
          @timestamps=Hash.new() unless defined?(@timestamps) && !@timestamps.nil?()
          return @timestamps[name.intern]
        end
      end

    end
  end
end
