# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Output
    class Versioned < Base
      def initialize(timestamp_format=nil,write_timestamp=nil,read_timestamp=nil,symlink_current=true,base=nil)
        super(base)
        @symlink_current=symlink_current
        @write_timestamp=write_timestamp
        @write_timestamp=TimeStamp.new() unless @write_timestamp
        @read_timestamp=read_timestamp
        unless @read_timestamp
          @read_timestamp=TimeStamp.new()
          @read_timestamp.special=:current
        end
        @read_timestamp_format=timestamp_format
        @read_timestamp_format=@read_timestamp.default_format unless @read_timestamp_format
        @write_timestamp_format=timestamp_format
        @write_timestamp_format=@write_timestamp.default_format unless @write_timestamp_format
      end
      attr_accessor :read_timestamp, :read_timestamp_format
      attr_accessor :write_timestamp, :write_timestamp_format

      def timestamp_format=(timestamp_format)
        @read_timestamp_format=timestamp_format
        @read_timestamp_format=@read_timestamp.default_format unless @read_timestamp_format
        @write_timestamp_format=timestamp_format
        @write_timestamp_format=@write_timestamp.default_format unless @write_timestamp_format
      end

      def mkdir(file,dirname,additional)
        if file.nil?()
          super(file,dirname,additional)
        else
          dir=File.join(@base,file)
          @@dir_mutex.synchronize {
            FileUtils.mkdir_p(dir) unless Dir.exists?(dir)
          }
          result_dir=dir.clone()
          ts=additional
          ts.each do |t|
            symlink=File.join(result_dir.clone,'current')
            result_dir=File.join(result_dir,t)
            @@dir_mutex.synchronize {
              FileUtils.mkdir_p(result_dir) unless Dir.exists?(result_dir)
              if File.exists?(symlink)
                FileUtils.remove_entry_secure(symlink, true)
                FileUtils.ln_sf(t,symlink)
              else
                FileUtils.ln_sf(t,symlink)
              end if @symlink_current
            }
          end unless ts.nil?()
        end
      end

      def build_filename_write(args)
        dir=File.join(@base,args)
        result_dir=dir.clone()
        ts=@write_timestamp.send("get_array_#{@write_timestamp_format}".intern)
        ts.each do |t|
          result_dir=File.join(result_dir,t)
        end unless ts.nil?()
        return result_dir,args[-1],ts.clone()
      end

      def build_filename_read(args)
        dir=File.join(@base,args)
        result_dir=dir.clone()
        ts=@read_timestamp.send("get_array_#{@read_timestamp_format}".intern)
        ts.each do |t|
          if @read_timestamp.special && @read_timestamp.special==:current
            result_dir=File.join(result_dir,'current')
          else
            result_dir=File.join(result_dir,t)
          end
        end unless ts.nil?()
        return result_dir,args[-1]
      end
    end
  end
end
