# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Timing
    class Timer
      TimingEntry=Struct.new(:name,:description,:start,:stop)
      include Ghun::Base::Logging

      def initialize(log_source=Ghun::Log::Source::BASE)
        init_logging(log_source,Ghun::Log::Type::TIMING)
        @timings=Hash.new()
        @enabled=true
      end

      @timings=Hash.new()
      @enabled=true
      def register(name,description)
        return unless @enabled
        if @timings.include?(name) then
          @timings[name].description=description
          @timings[name].description=name.to_s if @timings[name].description.nil?() || @timings[name].description==""
        else
          @timings[name]=TimingEntry.new(name.to_s,description)
          @timings[name].description=name.to_s if @timings[name].description.nil?() || @timings[name].description==""
        end
      end

      def unregister(name)
        return unless @enabled
        @timings.delete(name) if @timings.include?(name)
      end

      def enable
        @enabled=true
      end

      def disable
        @enabled=false
      end

      def start(name,additional=nil)
        return unless @enabled
        if @timings.include?(name) then
          @timings[name].start=Time.now()
          @timings[name].stop=nil
          debug("#{@timings[name].description}#{(!additional.nil?())?(" (#{additional}) "):(" ")}started at #{@timings[name].start}")
        end
      end

      def state(name,additional=nil)
        return unless @enabled
        if @timings[name].stop.nil?() then
          tmp=Time.now()
          debug("#{@timings[name].description}#{(!additional.nil?())?(" (#{additional}) "):(" ")}started at #{@timings[name].start}")
          debug("#{@timings[name].description} is running for #{tmp - @timings[name].start} seconds")
        else
          debug("#{@timings[name].description}#{(!additional.nil?())?(" (#{additional}) "):(" ")}started at #{@timings[name].start}")
          debug("#{@timings[name].description} stopped at #{@timings[name].stop}")
          debug("#{@timings[name].description} took #{@timings[name].stop - @timings[name].start} seconds")
        end if @timings.include?(name)
      end

      def stop(name,additional=nil)
        return unless @enabled
        if @timings.include?(name) && !@timings[name].nil?() && !@timings[name].start.nil?() then
          @timings[name].stop=Time.now()
          debug("#{@timings[name].description}#{(!additional.nil?())?(" (#{additional}) "):(" ")}stopped at #{@timings[name].stop}")
          debug("#{@timings[name].description} took #{@timings[name].stop - @timings[name].start} seconds")
        end
      end

      def output(name,per_x=nil, x_name=nil,additional=nil)
        return unless @enabled
        if @timings.include?(name) then
          tmp=nil
          if @timings[name].stop.nil?()
            tmp=Time.now
            state(name)
          else
            tmp=@timings[name].stop
          end
          unless per_x.nil?() || !per_x.is_a?(Numeric) then
            x=x_name || "THING"
            debug("#{@timings[name].description}#{(!additional.nil?())?(" (#{additional}) "):(" ")}handled #{per_x} #{x}s")
            debug("#{@timings[name].description}#{(!additional.nil?())?(" (#{additional}) "):(" ")}took #{per_x/(tmp - @timings[name].start)} #{x}s per second")
            debug("#{@timings[name].description}#{(!additional.nil?())?(" (#{additional}) "):(" ")}took #{(tmp - @timings[name].start)/per_x} seconds per #{x}")
          end
        end
      end
    end
  end
end
