# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Remote
    REMOTE_CONNECTION_SELECTOR=Ghun::Base::Selector.new("ConnectionType",[:type,:version],false,Ghun::Log::Source::REMOTE,Ghun::Log::Type::BASE)
    Ghun::Remote::REMOTE_CONNECTION_SELECTOR.register_member(:none_connection,[:none,nil])
    @type='none'
    Ghun::Base::Blackboard.config.declare_key(:"connection.#{@type}.max_concurrent_connections", :uint, 64, true)
    class Base < Ghun::Base::StatefullConnection
      def initialize(host,auth,thread_handler,type,mode=:sync,keep_connection=true)
        super(mode,type,keep_connection,Ghun::Log::Source::REMOTE)
        @host=host
        @auth=auth
        enable_wait_reporting(thread_handler)
      end

      def self.max_concurrent_connections()
        return Ghun::Base::Blackboard.config["connection.#{@type}.max_concurrent_connections"]
      end

      def max_concurrent_connections()
        self.class.max_concurrent_connections()
      end
    end
  end
end
