# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST

module Ghun
  module Remote
    class BasePlainSSH < Ghun::Remote::Base
      @type='ssh_v2'
      Ghun::Base::Blackboard.config.declare_key(:"connection.#{@type}.max_concurrent_connections", :uint, 16, true)
      Ghun::Base::Blackboard.config.declare_key(:"connection.#{@type}.connect_retries", :uint, 2, true)
      Ghun::Base::Blackboard.config.declare_key(:"connection.#{@type}.connect_retry_wait", :uint, 30, true)
      Ghun::Base::Blackboard.config.declare_key(:"connection.#{@type}.connect_retry_wait_first_time", :uint, 30, true)
      Ghun::Base::Blackboard.config.declare_key(:"connection.#{@type}.execute_retries", :uint, 2, true)
      Ghun::Base::Blackboard.config.declare_key(:"connection.#{@type}.execute_retry_wait", :uint, 10, true)
      Ghun::Base::Blackboard.config.declare_key(:"connection.#{@type}.execute_retry_wait_first_time", :uint, 10, true)
      def initialize(host,auth,thread_handler=nil,strip_motd=true,mode=:sync,keep_connection=true)
        super(host,auth,thread_handler,:ssh_v2,mode,keep_connection)
        @strip_motd=strip_motd
        @motd=nil
        begin
          raise Ghun::Auth::MissingAuthElementError if @auth.nil?()
        rescue => e
          error "No Auth given" ,e
          raise
        end
      end

      def run_command(command,failed_output_stdout=[],failed_output_stderr=[],allow_empty_result=false)
        @motd=execute_request({:command => '',:failed_output_stdout => [], :failed_output_stderr => [], :allow_empty_result => true}) if @motd.nil?() && @strip_motd
        if command.is_a?(Array)
          commands=Array.new()
          command.each do |c|
            commands << {:command => c, :failed_output_stdout => failed_output_stdout, :failed_output_stderr => failed_output_stderr, :allow_empty_result => allow_empty_result}
          end
          return execute_request(commands)
        elsif command.is_a?(Hash)
          return execute_request(command)
        else
          return execute_request({:command => command, :failed_output_stdout => failed_output_stdout, :failed_output_stderr => failed_output_stderr, :allow_empty_result => allow_empty_result})
        end
      end

      def enqueue_command(id,command,failed_output_stdout=[],failed_output_stderr=[],allow_empty_result=false)
        @motd=execute_request({:command => '',:failed_output_stdout => [], :failed_output_stderr => []}, :allow_empty_result => true) if @motd.nil?() && @strip_motd
        enqueue_request(id,{:command => command, :failed_output_stdout => failed_output_stdout, :failed_output_stderr => failed_output_stderr, :allow_empty_result => allow_empty_result})
      end

    end
  end
end

if Ghun::Base::Blackboard.ruby_engine==:jruby
  Ghun::Base.relative_require_if_exists(__FILE__, "ssh.inc.java.rb")
else
  Ghun::Base.relative_require_if_exists(__FILE__, "ssh.inc.ruby.rb")
end
