#!/bin/bash
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST


set -eu

basePath="$(dirname $(readlink -f $0))/../"
appPath="${basePath}/app/bin/"
localPath="${basePath}/local/bin/"
logPath="${basePath}/../log/"

#FIXME: should be false for ghun release versions
developmentMode="true"
rvmRubyName=""
rvmGemsetName=""
rubyOpts=""

self="$(basename ${0})"
component="${self%.sh}"
if [ "${component}" = "base" ]; then
  if [ -z "${1:-""}" ]; then
    echo "Nothing to do"
  else
    component=${1}
    shift
  fi
fi

if [ -d "${appPath}" -a -f "${appPath}/base.sh" ]; then
  source "${appPath}/base.sh"
fi
if [ -d "${localPath}" -a -f "${localPath}/base.sh" ]; then
  source "${localPath}/base.sh"
fi


if [ "${component}" = "irb" ]; then
  rubyOpts="${rubyOpts} -S"
  run="irb"
  component="--readline"
  developmentMode="false"
else
  run="${basePath}/bin/base.rb"
  logPath="${logPath}/${component}"
fi

set +eu
if [ -f "${HOME}/.rvm/scripts/rvm" ]; then
  source "${HOME}/.rvm/scripts/rvm"
elif [ -f "/etc/profile.d/rvm.sh" ]; then
  source "/etc/profile.d/rvm.sh"
fi

if [ -n "${rvmRubyName:-""}" ]; then
  if [ -n "${rvmGemsetName:-""}" ]; then
    rvm "${rvmRubyName}"@"${rvmGemsetName}"
  else
    rvm "${rvmRubyName}"
  fi
fi

rubyPath="$(which ruby)"

if [ "${developmentMode}" = "true" ]; then
  mkdir -p "${logPath}"
  time ${rubyPath} ${rubyOpts} "${run}" "${component}" $@ 2>&1 | tee "${logPath}/$(date +%s)_$$_output.log"
else
  ${rubyPath} ${rubyOpts} "${run}" "${component}" $@
fi
