# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST'

# This file is loaded by the global base.rb file, after loading the common and
# the component specific setup.inc.rb, so all required modules are loaded when
# this file is executed.

# Enter the code of your application here, the framework will shutdown the
# the application when all statements of this file are executed.
# base.rb will catch all exception not handled by your code and will output or
# log the exception. After such an exception shutdown can be run.

class Array
  def sum()
    inject(0.0) { |result,el| result + el}
  end

  def mean()
    sum().to_f() / size()
  end
end


runs=50
types=[:classic,:new_no_annotation_jena,:full,:snort,:arp,:foo,:fullts,:snortts,:arpts,:foots,:nnfull,:nnfullts]
evaluation_type=ARGV[0].downcase.intern
if types.include?(evaluation_type)
  puts "Evaluating #{evaluation_type} with #{runs} runs"
else
  puts "Unknown evaluation type #{evaluation_type}"
  exit
end

queries={
  :classic => 'SELECT * WHERE { ?ip no:ipMac ?mac . ?mac no:hasMacAddressValue "%%" . ?ip no:hasLayer3AddressValue ?ipv }',
  :new_no_annotation_jena => 'SELECT * WHERE { ?s a owl:Axiom . ?s owl:annotatedSource ?ip . ?s owl:annotatedProperty no:ipMac . ?s owl:annotatedTarget ?mac . ?mac no:hasMacAddressValue "%%" . ?ip no:hasLayer3AddressValue ?ipv}',
  :nnfull => 'SELECT * WHERE { ?s a owl:Axiom . ?s owl:annotatedSource ?ip . ?s owl:annotatedProperty no:ipMac . ?s owl:annotatedTarget ?mac . ?mac no:hasMacAddressValue "%%" . ?ip no:hasLayer3AddressValue ?ipv}',
  :nnfullts => 'SELECT * WHERE { ?s a owl:Axiom . ?s owl:annotatedSource ?ip . ?s owl:annotatedProperty no:ipMac . ?s owl:annotatedTarget ?mac . ?mac no:hasMacAddressValue "%%" . ?ip no:hasLayer3AddressValue ?ipv}',
  :new_no_annotation_owlapi => 'SELECT * WHERE { ?ip no:ipMac ?mac . ?mac no:hasMacAddressValue "%%" . ?ip no:hasLayer3AddressValue ?ipv}',
  :full => 'SELECT * WHERE { ?s a owl:Axiom . ?s owl:annotatedSource ?ip . ?s owl:annotatedProperty no:ipMac . ?s owl:annotatedTarget ?mac . ?mac no:hasMacAddressValue "%%" . ?s no:provenance ?prov . ?ip no:hasLayer3AddressValue ?ipv}',
  :fullts => 'SELECT * WHERE { ?s a owl:Axiom . ?s owl:annotatedSource ?ip . ?s owl:annotatedProperty no:ipMac . ?s owl:annotatedTarget ?mac . ?mac no:hasMacAddressValue "%%" . ?s no:provenance ?prov . ?s no:provenanceTimestamp ?provts . ?ip no:hasLayer3AddressValue ?ipv}',
  :snort => 'SELECT * WHERE { ?s a owl:Axiom . ?s owl:annotatedSource ?ip . ?s owl:annotatedProperty no:ipMac . ?s owl:annotatedTarget ?mac . ?mac no:hasMacAddressValue "%%" . ?s no:provenance ?prov . ?ip no:hasLayer3AddressValue ?ipv . ?s no:provenance ?prov . FILTER(REGEX(STR(?prov), "snort:","i"))}',
  :arp => 'SELECT * WHERE { ?s a owl:Axiom . ?s owl:annotatedSource ?ip . ?s owl:annotatedProperty no:ipMac . ?s owl:annotatedTarget ?mac . ?mac no:hasMacAddressValue "%%" . ?s no:provenance ?prov . ?ip no:hasLayer3AddressValue ?ipv . ?s no:provenance ?prov . FILTER(REGEX(STR(?prov), "arp:","i"))}',
  :foo => 'SELECT * WHERE { ?s a owl:Axiom . ?s owl:annotatedSource ?ip . ?s owl:annotatedProperty no:ipMac . ?s owl:annotatedTarget ?mac . ?mac no:hasMacAddressValue "%%" . ?s no:provenance ?prov . ?ip no:hasLayer3AddressValue ?ipv . ?s no:provenance ?prov . FILTER(REGEX(STR(?prov), "foo:","i"))}',
  :snortts => 'SELECT * WHERE { ?s a owl:Axiom . ?s owl:annotatedSource ?ip . ?s owl:annotatedProperty no:ipMac . ?s owl:annotatedTarget ?mac . ?mac no:hasMacAddressValue "%%" . ?s no:provenance ?prov . ?s no:provenanceTimestamp ?provts . ?ip no:hasLayer3AddressValue ?ipv . ?s no:provenance ?prov . FILTER(REGEX(STR(?prov), "snort:","i"))}',
  :arpts => 'SELECT * WHERE { ?s a owl:Axiom . ?s owl:annotatedSource ?ip . ?s owl:annotatedProperty no:ipMac . ?s owl:annotatedTarget ?mac . ?mac no:hasMacAddressValue "%%" . ?s no:provenance ?prov . ?s no:provenanceTimestamp ?provts . ?ip no:hasLayer3AddressValue ?ipv . ?s no:provenance ?prov . FILTER(REGEX(STR(?prov), "arp:","i"))}',
  :foots => 'SELECT * WHERE { ?s a owl:Axiom . ?s owl:annotatedSource ?ip . ?s owl:annotatedProperty no:ipMac . ?s owl:annotatedTarget ?mac . ?mac no:hasMacAddressValue "%%" . ?s no:provenance ?prov . ?s no:provenanceTimestamp ?provts . ?ip no:hasLayer3AddressValue ?ipv . ?s no:provenance ?prov . FILTER(REGEX(STR(?prov), "foo:","i"))}',
}

@handler=Ghun::Base::Blackboard.ontology

used=["00005e005300","00005e005301","00005e005302","00005e005303","00005e005304","00005e005305","00005e005306","00005e005307","00005e005308","00005e005310","00005e005311","00005e005312","00005e005313","00005e005314","00005e005315","00005e005316","00005e005317","00005e005318","00005e005319","00005e00531a","00005e00531c","00005e00531d","00005e00531e","00005e00531f","00005e005320","00005e005321","00005e005322","00005e005323","00005e005324","00005e005325","00005e005326","00005e005327","00005e005328","00005e005329","00005e00532a","00005e00532b","00005e00532c","00005e00532d","00005e00532e","00005e00532f","00005e005330","00005e005331","00005e005333","00005e005334","00005e005335","00005e005336","00005e005337","00005e005338","00005e005339","00005e00533a","00005e00533b","00005e00533c","00005e00533d","00005e00533e","00005e00533f","00005e005340","00005e005341","00005e005342","00005e005343","00005e005344","00005e005345","00005e005346","00005e005347","00005e005348"]
unused=["00005e005309","00005e00530a","00005e00530b","00005e00530c","00005e00530d","00005e00530e","00005e00530f","00005e00531b","00005e005332","00005e005349","00005e00534a","00005e00534b","00005e00534c","00005e00534d","00005e00534e","00005e00534f","00005e005350","00005e005351","00005e005352","00005e005353","00005e005354","00005e005355","00005e005356","00005e005357","00005e005358","00005e005359","00005e00535a","00005e00535b","00005e00535c","00005e00535d","00005e00535e","00005e00535f","00005e005360","00005e005361","00005e005362","00005e005363","00005e005364","00005e005365","00005e005366","00005e005367","00005e005368","00005e005369","00005e00536a","00005e00536b","00005e00536c","00005e00536d","00005e00536e","00005e00536f","00005e005370","00005e005371","00005e005372","00005e005373","00005e005374","00005e005375","00005e005376","00005e005377","00005e005378","00005e005379","00005e00537a","00005e00537b","00005e00537c","00005e00537d","00005e00537e","00005e00537f","00005e005380","00005e005381","00005e005382","00005e005383","00005e005384","00005e005385","00005e005386","00005e005387","00005e005388","00005e005389","00005e00538a","00005e00538b","00005e00538c","00005e00538d","00005e00538e","00005e00538f","00005e005390","00005e005391","00005e005392","00005e005393","00005e005394","00005e005395","00005e005396","00005e005397","00005e005398","00005e005399","00005e00539a","00005e00539b","00005e00539c","00005e00539d","00005e00539e","00005e00539f","00005e0053a0","00005e0053a1","00005e0053a2","00005e0053a3","00005e0053a4","00005e0053a5","00005e0053a6","00005e0053a7","00005e0053a8","00005e0053a9","00005e0053aa","00005e0053ab","00005e0053ac","00005e0053ad","00005e0053ae","00005e0053af","00005e0053b0","00005e0053b1","00005e0053b2","00005e0053b3","00005e0053b4","00005e0053b5","00005e0053b6","00005e0053b7","00005e0053b8","00005e0053b9","00005e0053ba","00005e0053bb","00005e0053bc","00005e0053bd","00005e0053be","00005e0053bf","00005e0053c0","00005e0053c1","00005e0053c2","00005e0053c3","00005e0053c4","00005e0053c5","00005e0053c6","00005e0053c7","00005e0053c8","00005e0053c9","00005e0053ca","00005e0053cb","00005e0053cc","00005e0053cd","00005e0053ce","00005e0053cf","00005e0053d0","00005e0053d1","00005e0053d2","00005e0053d3","00005e0053d4","00005e0053d5","00005e0053d6","00005e0053d7","00005e0053d8","00005e0053d9","00005e0053da","00005e0053db","00005e0053dc","00005e0053dd","00005e0053de","00005e0053df","00005e0053e0","00005e0053e1","00005e0053e2","00005e0053e3","00005e0053e4","00005e0053e5","00005e0053e6","00005e0053e7","00005e0053e8","00005e0053e9","00005e0053ea","00005e0053eb","00005e0053ec","00005e0053ed","00005e0053ee","00005e0053ef","00005e0053f0","00005e0053f1","00005e0053f2","00005e0053f3","00005e0053f4","00005e0053f5","00005e0053f6","00005e0053f7","00005e0053f8","00005e0053f9","00005e0053fa","00005e0053fb","00005e0053fc","00005e0053fd","00005e0053fe","00005e0053ff"]

used_queries=[]
unused_queries=[]

used_result=[]
unused_result=[]

used.each do |mac|
  used_queries << queries[evaluation_type].gsub(/%%/,mac)
end
unused.each do |mac|
  unused_queries << queries[evaluation_type].gsub(/%%/,mac)
end

durations=Hash.new()
computed_durations=Hash.new
durations[:global_durations]=Array.new()
durations[:used_global_durations]=Array.new()
durations[:unused_global_durations]=Array.new()
durations[:used_durations]=Array.new()
durations[:unused_durations]=Array.new()

(0...(runs)).each do |index|
  puts "Starting run #{index}/#{runs} for #{evaluation_type}"
  @ontology=@handler.init_ontology(evaluation_type)

  def @ontology.format_result(result_raw,list_namespaces,show_datatype_properties,show_anonymous_nodes)
    return result_raw
  end

  duration=Hash.new()
  duration[:before]=Time.now()
  duration[:before_used]=duration[:before]

  used_queries.each_with_index do |q,i|
    before=Time.now()
    used_result << @ontology.query(q,true,true)
    after=Time.now()
    durations[:used_durations] << (after-before)
  end

  duration[:after_used]=Time.now()
  duration[:before_unused]=duration[:after_used]

  unused_queries.each do |q|
    before=Time.now()
    unused_result << @ontology.query(q,true,true)
    after=Time.now()
    durations[:unused_durations] << (after-before)
  end
  duration[:after_unused]=Time.now()
  duration[:after]=duration[:after_unused]

  @handler.destroy_ontology(evaluation_type)
  @ontology=nil

  durations[:used_global_durations] << duration[:after_used]-duration[:before_used]
  durations[:unused_global_durations] << duration[:after_unused]-duration[:before_unused]
  durations[:global_durations] << duration[:after]-duration[:before]
end

computed_durations[:min_unused]=durations[:unused_durations].min()
computed_durations[:max_unused]=durations[:unused_durations].max()
computed_durations[:avg_unused]=durations[:unused_durations].mean()
computed_durations[:count_unused]=durations[:unused_durations].length()
computed_durations[:min_used]=durations[:used_durations].min()
computed_durations[:max_used]=durations[:used_durations].max()
computed_durations[:avg_used]=durations[:used_durations].mean()
computed_durations[:count_used]=durations[:used_durations].length()

computed_durations[:min_unused_global]=durations[:unused_global_durations].min()
computed_durations[:max_unused_global]=durations[:unused_global_durations].max()
computed_durations[:avg_unused_global]=durations[:unused_global_durations].mean()
computed_durations[:count_unused_global]=durations[:unused_global_durations].length()
computed_durations[:min_used_global]=durations[:used_global_durations].min()
computed_durations[:max_used_global]=durations[:used_global_durations].max()
computed_durations[:avg_used_global]=durations[:used_global_durations].mean()
computed_durations[:count_used_global]=durations[:used_global_durations].length()
computed_durations[:min_global]=durations[:global_durations].min()
computed_durations[:max_global]=durations[:global_durations].max()
computed_durations[:avg_global]=durations[:global_durations].mean()
computed_durations[:count_global]=durations[:global_durations].length()

puts "Durations for #{evaluation_type} after #{runs} runs (count/min/max/avg)"
puts "Single used queries: #{computed_durations[:count_used]} #{computed_durations[:min_used]} #{computed_durations[:max_used]} #{computed_durations[:avg_used]}"
puts "Single unused queries: #{computed_durations[:count_unused]} #{computed_durations[:min_unused]} #{computed_durations[:max_unused]} #{computed_durations[:avg_unused]}"
puts "Global used queries: #{computed_durations[:count_used_global]} #{computed_durations[:min_used_global]} #{computed_durations[:max_used_global]} #{computed_durations[:avg_used_global]}"
puts "Global unused queries: #{computed_durations[:count_unused_global]} #{computed_durations[:min_unused_global]} #{computed_durations[:max_unused_global]} #{computed_durations[:avg_unused_global]}"
puts "Global: #{computed_durations[:count_global]} #{computed_durations[:min_global]} #{computed_durations[:max_global]} #{computed_durations[:avg_global]}"


#IRB.start_session(binding)
