# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
Ghun::Base::java_require("ifmap")
module Iof
  module IfMap
    class SimuConnector < Connector
      Ghun::Base::Blackboard.config.declare_key(:"simu.mapserver", :string)
      def initialize(type=:simu_ifmap)
        @mapserver=config[:"simu.mapserver"]
        super(@mapserver,type)
        @query=@query=Iof::Query::Simu.new()
        @simu_namespace="http://sit.fraunhofer.de/2014/INFRASTRUCTURE-IDENTIFIER/1"
        @simu_meta_namespace="http://sit.fraunhofer.de/2014/INFRASTRUCTURE-METADATA/1"
        @simu_prefix="io"
        @simu_meta_prefix="io-meta"
      end

      def run()
        ensure_connection()
        @query.run_publish()
        old_state=@query.old_state
        state=@query.state


        unless old_state.nil?()
          #XXX dirty workaround
          disconnect()
          connect()
        end

        ifmap_io=device("IO")
        state[:devices].each do |dlabel,device|
          ifmap_device=device(device[:name])
          device_publishes=[]
          meta_device_detected=vendor_specific_metadata("device-discovered-by", :single_value, {"discovered-by" => "IO"})
          device_publishes << publish_update(ifmap_io,ifmap_device,meta_device_detected)
          device[:interfaces].each do |ilabel,interface|
            ifmap_interface=interface(interface[:name])
            meta_device_interface=vendor_specific_metadata("device-interface")
            device_publishes << publish_update(ifmap_device,ifmap_interface,meta_device_interface)
            if interface[:mac_address]
              ifmap_specific_mac=specific_address(:mac, interface[:mac_address])
              ifmap_generic_mac=generic_address(:mac, interface[:mac_address])
              meta_device_specific_mac=vendor_specific_metadata("device-mac")
              meta_device_generic_mac=vendor_specific_metadata("device-address")
              meta_interface_specific_mac=vendor_specific_metadata("interface-mac")
              meta_interface_generic_mac=vendor_specific_metadata("interface-address")
              device_publishes << publish_update(ifmap_device,ifmap_specific_mac,meta_device_specific_mac)
              device_publishes << publish_update(ifmap_device,ifmap_generic_mac,meta_device_generic_mac)
              device_publishes << publish_update(ifmap_interface,ifmap_specific_mac,meta_interface_specific_mac)
              device_publishes << publish_update(ifmap_interface,ifmap_generic_mac,meta_interface_generic_mac)
              if interface[:native_vlan]
                ifmap_specific_vlan=specific_network(:vlan, interface[:native_vlan],nil)
                ifmap_generic_vlan=generic_network(:vlan, interface[:native_vlan],nil)
                meta_specific_address_network=vendor_specific_metadata("mac-vlan")
                meta_generic_address_network=vendor_specific_metadata("address-network")
                meta_specific_interface_network=vendor_specific_metadata("interface-vlan")
                meta_generic_interface_network=vendor_specific_metadata("interface-network")
                device_publishes << publish_update(ifmap_specific_mac,ifmap_specific_vlan,meta_specific_address_network)
                device_publishes << publish_update(ifmap_generic_mac,ifmap_generic_vlan,meta_generic_address_network)
                device_publishes << publish_update(ifmap_interface,ifmap_specific_vlan,meta_specific_interface_network)
                device_publishes << publish_update(ifmap_interface,ifmap_generic_vlan,meta_generic_interface_network)
              end
              if interface[:tagged_vlans]
                interface[:tagged_vlans].each do |vlan|
                  ifmap_specific_vlan=specific_network(:vlan, vlan,nil)
                  ifmap_generic_vlan=generic_network(:vlan, vlan,nil)
                  meta_specific_address_network=vendor_specific_metadata("mac-vlan")
                  meta_generic_address_network=vendor_specific_metadata("address-network")
                  meta_specific_interface_network=vendor_specific_metadata("interface-vlan")
                  meta_generic_interface_network=vendor_specific_metadata("interface-network")
                  device_publishes << publish_update(ifmap_specific_mac,ifmap_specific_vlan,meta_specific_address_network)
                  device_publishes << publish_update(ifmap_generic_mac,ifmap_generic_vlan,meta_generic_address_network)
                  device_publishes << publish_update(ifmap_interface,ifmap_specific_vlan,meta_specific_interface_network)
                  device_publishes << publish_update(ifmap_interface,ifmap_generic_vlan,meta_generic_interface_network)
                end
              end
            end
            if interface[:ipv4_address]
              ifmap_specific_ipv4=specific_address(:ipv4, interface[:ipv4_address].address.to_s)
              ifmap_generic_ipv4=generic_address(:ipv4, interface[:ipv4_address].address.to_s)
              meta_device_specific_ipv4=vendor_specific_metadata("device-ip")
              meta_device_generic_ipv4=vendor_specific_metadata("device-address")
              meta_interface_specific_ipv4=vendor_specific_metadata("interface-ip")
              meta_interface_generic_ipv4=vendor_specific_metadata("device-address")
              device_publishes << publish_update(ifmap_device,ifmap_specific_ipv4,meta_device_specific_ipv4)
              device_publishes << publish_update(ifmap_device,ifmap_generic_ipv4,meta_device_generic_ipv4)
              device_publishes << publish_update(ifmap_interface,ifmap_specific_ipv4,meta_interface_specific_ipv4)
              device_publishes << publish_update(ifmap_interface,ifmap_generic_ipv4,meta_interface_generic_ipv4)
              if interface[:ipv4_network]
                ifmap_specific_ipv4_network=specific_network(:ipv4, interface[:ipv4_network].address.to_s,interface[:ipv4_network].network.to_s)
                ifmap_generic_ipv4_network=generic_network(:ipv4, interface[:ipv4_network].address.to_s,interface[:ipv4_network].network.to_s)
                meta_specific_address_network=vendor_specific_metadata("ip-ipnet")
                meta_generic_address_network=vendor_specific_metadata("address-network")
                meta_specific_interface_network=vendor_specific_metadata("interface-ipnet")
                meta_generic_interface_network=vendor_specific_metadata("interface-network")
                device_publishes << publish_update(ifmap_specific_ipv4,ifmap_specific_ipv4_network,meta_specific_address_network)
                device_publishes << publish_update(ifmap_generic_ipv4,ifmap_generic_ipv4_network,meta_generic_address_network)
                device_publishes << publish_update(ifmap_interface,ifmap_specific_ipv4_network,meta_specific_interface_network)
                device_publishes << publish_update(ifmap_interface,ifmap_generic_ipv4_network,meta_generic_interface_network)
              end
            end
            if interface[:ipv6_address]
              ifmap_specific_ipv6=specific_address(:ipv6, interface[:ipv6_address].address.to_s)
              ifmap_generic_ipv6=generic_address(:ipv6, interface[:ipv6_address].address.to_s)
              meta_device_specific_ipv6=vendor_specific_metadata("device-ip")
              meta_device_generic_ipv6=vendor_specific_metadata("device-address")
              meta_interface_specific_ipv6=vendor_specific_metadata("interface-ip")
              meta_interface_generic_ipv6=vendor_specific_metadata("device-address")
              device_publishes << publish_update(ifmap_device,ifmap_specific_ipv6,meta_device_specific_ipv6)
              device_publishes << publish_update(ifmap_device,ifmap_generic_ipv6,meta_device_generic_ipv6)
              device_publishes << publish_update(ifmap_interface,ifmap_specific_ipv6,meta_interface_specific_ipv6)
              device_publishes << publish_update(ifmap_interface,ifmap_generic_ipv6,meta_interface_generic_ipv6)
              if interface[:ipv6_network]
                ifmap_specific_ipv6_network=specific_network(:ipv6, interface[:ipv6_network].address.to_s,interface[:ipv6_network].network.to_s)
                ifmap_generic_ipv6_network=generic_network(:ipv6, interface[:ipv6_network].address.to_s,interface[:ipv6_network].network.to_s)
                meta_specific_address_network=vendor_specific_metadata("ip-ipnet")
                meta_generic_address_network=vendor_specific_metadata("address-network")
                meta_specific_interface_network=vendor_specific_metadata("interface-ipnet")
                meta_generic_interface_network=vendor_specific_metadata("interface-network")
                device_publishes << publish_update(ifmap_specific_ipv6,ifmap_specific_ipv6_network,meta_specific_address_network)
                device_publishes << publish_update(ifmap_generic_ipv6,ifmap_generic_ipv6_network,meta_generic_address_network)
                device_publishes << publish_update(ifmap_interface,ifmap_specific_ipv6_network,meta_specific_interface_network)
                device_publishes << publish_update(ifmap_interface,ifmap_generic_ipv6_network,meta_generic_interface_network)
              end
            end
          end
          publish(device_publishes)
        end

        published_devices=Array.new()
        published_interfaces=Array.new()
        state[:connections].each do |component,interfaces|
          connection_publishes=[]
          ifmap_device01=device(component.to_s)
          interfaces.each do |interface,neighbor|
            ifmap_interface01=interface(interface.to_s)
            ifmap_device02=device(neighbor[0])
            ifmap_interface02=interface(neighbor[1])
            meta_devices_connected=vendor_specific_metadata("devices-connected")
            meta_interfaces_connected=vendor_specific_metadata("interfaces-connected")
            d=[component.to_s,neighbor[0].to_s].sort
            i=[interface.to_s,neighbor[1].to_s].sort
            unless published_devices.include?(d)
              published_devices << d
              connection_publishes << publish_update(ifmap_device01,ifmap_device02,meta_devices_connected)
            end
            unless published_interfaces.include?(i)
              published_interfaces << i
              connection_publishes << publish_update(ifmap_interface01,ifmap_interface02,meta_interfaces_connected)
            end
          end
          publish(connection_publishes) unless connection_publishes.empty?()
        end
        published_devices=nil
        published_interfaces=nil

        ipmac_publishes=[]
        state[:ipmac].each do |im|
          ip_type=(IPAddress.valid_ipv4?(im[:ip]))?(:ipv4):(:ipv6)
          ifmap_generic_mac=generic_address(:mac, im[:mac])
          ifmap_generic_ip=generic_address(ip_type,im[:ip])
          ifmap_specific_mac=specific_address(:mac, im[:mac])
          ifmap_specific_ip=specific_address(ip_type,im[:ip])
          meta_specific_l2l3=ip_mac()
          meta_generic_l2l3=vendor_specific_metadata("layer3address-layer2address")
          ipmac_publishes << publish_update(ifmap_generic_mac,ifmap_generic_ip,meta_generic_l2l3)
          ipmac_publishes << publish_update(ifmap_specific_mac,ifmap_specific_ip,meta_specific_l2l3)
        end
        publish(ipmac_publishes)
        ipmac_publishes=nil

        consistency_publishes=[]
        state[:consistency][:address].each do |address,events|
          next if events.nil?() || events.empty?()
          address_type=if IPAddress.valid_ipv4?(address.to_s)
            :ipv4
          elsif IPAddress.valid_ipv6?(address.to_s)
            :ipv6
          else
            :mac
          end
          ifmap_specific_address=specific_address(address_type,address.to_s)
          ifmap_generic_address=generic_address(address_type,address.to_s)
          events.each do |event|
            ifmap_event=event(event,"address related configuration inconsistency")
            consistency_publishes << publish_notify(ifmap_specific_address, nil, ifmap_event)
            consistency_publishes << publish_notify(ifmap_generic_address, nil, ifmap_event)
          end
        end if state[:consistency].include?(:address)
        state[:consistency][:interface].each do |interface,events|
          next if events.nil?() || events.empty?()
          ifmap_interface=interface(interface.to_s)
          events.each do |event|
            ifmap_event=event(event,"interface related configuration inconsistency")
            #consistency_publishes << publish_update(ifmap_interface, nil, ifmap_event)
          end
        end if state[:consistency].include?(:interface)
        state[:consistency][:device].each do |device,events|
          next if events.nil?() || events.empty?()
          ifmap_device=device(device.to_s)
          events.each do |event|
            ifmap_event=event(event,"device related configuration inconsistency")
            consistency_publishes << publish_notify(ifmap_device, nil, ifmap_event)
          end
        end if state[:consistency].include?(:device)
        publish(consistency_publishes) unless consistency_publishes.empty?()
        consistency_publishes=nil
      end

    private

      def specific_address(type,address)
        case type
        when :ipv4
          ::IfMap::Identifier::Identifiers.createIp4(address)
        when :ipv6
          ::IfMap::Identifier::Identifiers.createIp6(convert_rfc5952_to_ifmap_v20(address))
        when :mac
          ::IfMap::Identifier::Identifiers.createMac(address)
        end
      end

      def generic_address(type,address)
        case type
        when :ipv4
          extended_identifier("address",{:layer => "3", :type => "IPv4", :value => address})
        when :ipv6
          extended_identifier("address",{:layer => "3", :type => "IPv6", :value => address})
        when :mac
          extended_identifier("address",{:layer => "2", :type => "MAC", :value => address})
        end
      end

      def specific_network(type,network,scope)
        case type
        when :ipv4
          extended_identifier("ipnetwork",{:prefix => scope, :type => "IPv4", :value => network})
        when :ipv6
          extended_identifier("ipnetwork",{:prefix => scope, :type => "IPv6", :value => convert_rfc5952_to_ifmap_v20(network)})
        when :vlan
          extended_identifier("vlan",{:id => network})
        end
      end

      def generic_network(type,network,scope)
        case type
        when :ipv4
          extended_identifier("network",{:layer => "3", :scope => scope, :type => "IPv4", :value => network})
        when :ipv6
          extended_identifier("network",{:layer => "3", :scope => scope, :type => "IPv6", :value => convert_rfc5952_to_ifmap_v20(network)})
        when :vlan
          extended_identifier("network",{:layer => "2", :type => "Ethernet", :value => network})
        end
      end

      def interface(name)
        extended_identifier("interface",{:layer => "combined_2_3", :name => name, :type => "physical"})
      end


      def extended_identifier(identifier,attributes={},ns=@simu_namespace,ns_prefix=@simu_prefix)
        attr=attributes.clone()
        super(identifier,attr,ns,ns_prefix)
      end

      def vendor_specific_metadata(name,cardinality=:single_value,attributes={},ns=@simu_namespace,ns_prefix=@simu_prefix)
        super(name,cardinality,attributes,ns,ns_prefix)
      end

      def event(name,type)
        vendor_specific_metadata("event", :multi_value, {"name" => name, "type" => type}, ::IfMap::Binding::IfmapStrings::STD_METADATA_NS_URI, ::IfMap::Binding::IfmapStrings::STD_METADATA_PREFIX)
      end
    end
  end
end
