# encoding: utf-8
# license: gpl3p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST

require 'ipaddress'
require 'yaml'

module Iof
  module Query
    class Simu < Base
      Ghun::Base::Blackboard.config.declare_key(:"simu.import.base_dir",:string,File.join(Ghun::Base::Blackboard.local.data_path,'simu','import'))
      Ghun::Base::Blackboard.config.declare_key(:"simu.import.dataset",:string)
      def initialize()
        super(:simu,[])
        @state=nil
        @old_state=nil
        @run_mutex=Monitor.new()
        @path=config[:"simu.import.base_dir"]
        @dataset=config[:"simu.import.dataset"]
        @networks=[]
        begin
          import_networks_file=File.join(@path,@dataset,'networks.yaml')
          if File.exists?(import_networks_file)
            content=File.read(import_networks_file)
            @networks=YAML.load(content)
          end
        rescue => e
          error "Failed to read networks.yaml", e
        end
      end
      attr_reader :state, :old_state

      def run_agenda(filename=File.join(Ghun::Base::Blackboard.local.data_path,"simu","agenda.txt"))
        @run_mutex.synchronize {
          if @state.nil?()
            debug "First run, querying initial state"
            @state=query_state()
          else
            debug "Update run, querying state and keeping old state"
            refresh_state()
          end
          result=format_agenda(@state[:devices],@state[:connections],@state[:ipmac])
          begin
            FileUtils.mkdir_p(File.dirname(filename))
            File.open(filename,'w') do |f|
              f.write result
            end
          rescue => e
            error "Error during file operation", e
            puts result
          end
        }
      end

      def run_publish()
        @run_mutex.synchronize {
          if @state.nil?()
            debug "First run, querying initial state"
            @state=query_state()
          else
            debug "Update run, querying state and keeping old state"
            refresh_state()
          end
        }
        return nil
      end



    private

      def refresh_state()
        restart_ontology()
        @old_state=@state
        @networks=[]
        begin
          import_networks_file=File.join(@path,@dataset,'networks.yaml')
          if File.exists?(import_networks_file)
            content=File.read(import_networks_file)
            @networks=YAML.load(content)
          end
        rescue => e
          error "Failed to read networks.yaml", e
        end
        @state=query_state()
      end

      def query_state()
        devices_raw=@ontology.query("SELECT DISTINCT * WHERE { ?d a no:ManagedNetworkComponent . OPTIONAL { ?d owl:topDataProperty ?v . ?d ?p ?v}}",true,true)
        devices=Hash.new()
        connections=Hash.new()
        devices_raw.each do |device|
          devices[device[:d].intern]=Hash.new unless devices.include?(device[:d].intern)
          d=devices[device[:d].intern]
          d[:interfaces]=Hash.new()
          connections[device[:d].intern]=Hash.new() unless connections.include?(device[:d].intern)
          d[:name]=device[:d]
          if device[:p]=="isSwitch" && device[:v].downcase=="true"
            d[:type]=:switch
          elsif device[:p]=="isRouter" && device[:v].downcase=="true"
            d[:type]=:router
          elsif device[:p]=="isPhone" && device[:v].downcase=="true"
            d[:type]=:phone
          elsif device[:p]=="isAccessPoint" && device[:v].downcase=="true"
            d[:type]=:ap
          else
            d[:type]=:endpoint
          end if device.include?(:p) && device.include?(:v)
          connections_raw=@ontology.query("SELECT DISTINCT ?c2 ?c1_l1 ?c2_l1 WHERE { <#{@ontology.prefixes[device[:__ns_d]]}#{device[:d]}> no:hasLayer1Connection ?c2 . <#{@ontology.prefixes[device[:__ns_d]]}#{device[:d]}> no:hasLayer1Interface ?c1_l1 . ?c2 no:hasLayer1Interface ?c2_l1 . ?c1_l1 no:isConnectedTo ?c2_l1}",true,true)
          connections_raw.each do |connection|
            connections[device[:d].intern]=Hash.new() unless connections.include?(device[:d].intern)
            connections[device[:d].intern][connection[:c1_l1].sub(/\//,'_').intern]=[connection[:c2].intern,connection[:c2_l1].sub(/\//,'_').intern]
            connections[connection[:c2].intern]=Hash.new() unless connections.include?(connection[:c2].intern)
            connections[connection[:c2].intern][connection[:c2_l1].sub(/\//,'_').intern]=[device[:d].intern,connection[:c1_l1].sub(/\//,'_').intern]
          end
          connections_raw=nil
          interfaces_raw=@ontology.query("SELECT DISTINCT ?l1 WHERE { <#{@ontology.prefixes[device[:__ns_d]]}#{device[:d]}> no:hasLayer1Interface ?l1}")
          interfaces_raw.each do |interface|
            d[:interfaces][interface[:l1].sub(/\//,'_').intern]=Hash.new()
            i=d[:interfaces][interface[:l1].sub(/\//,'_').intern]
            i[:name]=interface[:l1].sub(/\//,'_')
            l2_raw=@ontology.query("SELECT DISTINCT * WHERE { <#{@ontology.prefixes[interface[:__ns_l1]]}#{interface[:l1]}> no:hasEthernetInterface ?eth . OPTIONAL { ?eth no:hasMacAddress ?tmp1 . ?eth no:hasMacAddressValue ?mac}} ",true,true)
            i[:mac_address]=l2_raw[0][:mac].sub(/00005e0053/,'00:00:5e:00:53:') if l2_raw[0].include?(:mac)
            unless l2_raw.empty?()
              l2="#{@ontology.prefixes[l2_raw[0][:__ns_eth]]}#{l2_raw[0][:eth]}"
              native_raw=@ontology.query("SELECT DISTINCT * WHERE { <#{l2}> no:hasNativeVlan ?tmp1 . ?tmp1 no:hasVlanID ?vlan }",true,true)
              tagged_raw=@ontology.query("SELECT DISTINCT * WHERE { <#{l2}> no:hasTaggedVlan ?tmp1 . ?tmp1 no:hasVlanID ?vlan }",true,true)
              i[:native_vlan]=native_raw[0][:vlan] unless native_raw.empty?()
              unless tagged_raw.empty?()
                i[:tagged_vlans]=Array.new()
                tagged_raw.each do |line|
                  i[:tagged_vlans] << line[:vlan]
                end
                i[:tagged_vlans]=i[:tagged_vlans].compact().sort().uniq()
              end
              ipv4_a_raw=@ontology.query("SELECT DISTINCT * WHERE { <#{l2}> no:hasIPv4Interface ?v4 . ?v4 no:hasIPv4Address ?tmp1 . ?tmp1 ?p ?data . ?tmp1 no:hasLayer3AddressValue ?data} ",true,true)
              ipv4_n_raw=@ontology.query("SELECT DISTINCT * WHERE { <#{l2}> no:hasIPv4Interface ?v4 . ?v4 no:hasIPv4Network ?tmp1 . ?tmp1 ?p ?data . ?tmp1 no:hasLayer3AddressValue ?data} ",true,true)
              ipv6_a_raw=@ontology.query("SELECT DISTINCT * WHERE { <#{l2}> no:hasIPv6Interface ?v6 . ?v6 no:hasIPv6Address ?tmp1 . ?tmp1 ?p ?data . ?tmp1 no:hasLayer3AddressValue ?data} ",true,true)
              ipv6_n_raw=@ontology.query("SELECT DISTINCT * WHERE { <#{l2}> no:hasIPv6Interface ?v6 . ?v6 no:hasIPv6Network ?tmp1 . ?tmp1 ?p ?data . ?tmp1 no:hasLayer3AddressValue ?data} ",true,true)
              unless ipv4_a_raw.empty?()
                v4_a=Hash.new()
                ipv4_a_raw.each do |line|
                  case line[:p]
                  when "hasIPv4AddressValue"
                    v4_a[:address]=line[:data]
                  when "hasIPv4NetmaskValue"
                    v4_a[:netmask_long]=line[:data]
                  when "hasIPv4NetmaskLength"
                    v4_a[:netmask_short]=line[:data]
                  end
                end
                if v4_a.include?(:netmask_short) || v4_a.include?(:netmask_long)
                  i[:ipv4_address]=::IPAddress::IPv4.new("#{v4_a[:address]}/#{v4_a[:netmask_short] || v4_a[:netmask_long]}")
                else
                  i[:ipv4_address]=::IPAddress::IPv4.new(v4_a[:address])
                end if v4_a.include?(:address)
              end
              unless ipv4_n_raw.empty?()
                v4_n=Hash.new()
                ipv4_n_raw.each do |line|
                  case line[:p]
                  when "hasIPv4AddressValue"
                    v4_n[:address]=line[:data]
                  when "hasIPv4NetmaskValue"
                    v4_n[:netmask_long]=line[:data]
                  when "hasIPv4NetmaskLength"
                    v4_n[:netmask_short]=line[:data]
                  end
                end
                if v4_n.include?(:netmask_short) || v4_n.include?(:netmask_long)
                  i[:ipv4_network]=::IPAddress::IPv4.new("#{v4_n[:address]}/#{v4_n[:netmask_short] || v4_n[:netmask_long]}")
                else
                  i[:ipv4_network]=::IPAddress::IPv4.new(v4_n[:address])
                end if v4_n.include?(:address)
              end
              unless ipv6_a_raw.empty?()
                v6_a=Hash.new()
                ipv6_a_raw.each do |line|
                  case line[:p]
                  when "hasIPv6AddressValue"
                    v6_a[:address]=line[:data]
                  when "hasIPv6NetmaskLength"
                    v6_a[:netmask]=line[:data]
                  end
                end
                if v6_a.include?(:netmask)
                  i[:ipv6_address]=::IPAddress::IPv6.new("#{v6_a[:address]}/#{v6_a[:netmask]}")
                else
                  i[:ipv6_address]=::IPAddress::IPv6.new(v6_a[:address])
                end if v6_a.include?(:address)
              end
              unless ipv6_n_raw.empty?()
                v6_n=Hash.new()
                ipv6_n_raw.each do |line|
                  case line[:p]
                  when "hasIPv6AddressValue"
                    v6_n[:address]=line[:data]
                  when "hasIPv6NetmaskLength"
                    v6_n[:netmask_short]=line[:data]
                  end
                end
                if v6_n.include?(:netmask)
                  i[:ipv6_network]=::IPAddress::IPv6.new("#{v6_n[:address]}/#{v6_n[:netmask]}")
                else
                  i[:ipv6_network]=::IPAddress::IPv6.new(v6_n[:address])
                end if v6_n.include?(:address)
              end
            end
          end
        end
        devices_raw=nil

#        ARES 2015 proof of concept implementation
#        ipmac_raw=@ontology.query("SELECT ?ip ?mac ?prov ?pts WHERE { ?s a owl:Axiom . ?s owl:annotatedSource ?tmpip . ?s owl:annotatedProperty no:ipMac . ?s owl:annotatedTarget ?tmpmac . ?s no:provenance ?prov . ?s no:provenanceTimestamp ?pts . ?tmpip no:hasIPv4AddressValue ?ip . ?tmpmac no:hasMacAddressValue ?mac}",true,true)
#        ipmac=Array.new()
#        ipmac_raw.each do |line|
#          ipmac << {:ip => line[:ip], :mac => line[:mac].sub(/00005e0053/,'00:00:5e:00:53:') , :provenance => line[:prov].sub(/\^\^.*/,''), :timestamp => line[:pts].sub(/\^\^.*/,'').sub(/\+/,'')}
#        end
#        ipmac_raw=nil

        ipmac_raw=@ontology.query("SELECT ?ip ?mac WHERE { ?tmpip no:ipMac ?tmpmac . ?tmpip no:hasIPv4AddressValue ?ip . ?tmpmac no:hasMacAddressValue ?mac}",true,true)
        ipmac=Array.new()
        ipmac_raw.each do |line|
          ipmac << {:ip => line[:ip], :mac => line[:mac].sub(/00005e0053/,'00:00:5e:00:53:')}
        end
        ipmac_raw=nil
        consistency=Hash.new()
        consistency[:address]=Hash.new()
        consistency[:device]=Hash.new()
        consistency[:interface]=Hash.new()

         #TODO check consistency with networks.yaml
        devices.each do |dlabel,device|
          device[:interfaces].each do |ilabel,interface|
            if !interface[:native_vlan].nil?() || (!interface[:tagged_vlans].nil?() && !interface[:tagged_vlans].empty?())
              if (connections.include?(dlabel) && connections[dlabel].include?(ilabel))
                debug "#{dlabel}-#{ilabel} is connected to #{connections[dlabel][ilabel]}"
              elsif ilabel.to_s.match(/___Vlan/)
                debug "#{dlabel}-#{ilabel} is virtual interface"
              else
                consistency[:interface][ilabel]=Array.new() unless consistency[:interface].include?(ilabel)
                vlans=[]
                vlans << interface[:native_vlan] unless interface[:native_vlan].nil?()
                vlans += interface[:tagged_vlans] unless interface[:tagged_vlans].nil?()
                v=vlans.compact.uniq.sort.join(',')
                warn "Interface #{dlabel}-#{ilabel} has active vlans #{v}, but no connection"
                consistency[:interface][ilabel] << "Interface #{dlabel}-#{ilabel} has active vlans #{v}, but no connection"
              end
            else
              debug "#{dlabel}-#{ilabel} has no active vlans; no need for checking connections"
            end
          end
        end

        result={:devices => devices, :connections => connections, :ipmac => ipmac, :consistency => consistency}
        return result
      end

      def format_agenda(devices,connections,ipmac)
        result=""
        devices.each do |dlabel,device|
          result+="DeviceDetected( io => IO, device => #{device[:name]} );\n"
          device[:interfaces].each do |ilabel,interface|
            result+="AddInterfaceToDevice( device => #{device[:name]}, interface => #{interface[:name]} );\n"
            if interface[:mac_address]
              result+="AddAddressToInterface( device => #{device[:name]}, interface => #{interface[:name]}, type => MAC, address => #{interface[:mac_address]} );\n"
              if interface[:native_vlan]
                result+="AddNetworkToAddress( interface => #{interface[:name]}, type => MAC, address => #{interface[:mac_address]}, network => #{interface[:native_vlan]}, scope => none );\n"
              end
              if interface[:tagged_vlans]
                interface[:tagged_vlans].each do |vlan|
                  result+="AddNetworkToAddress( interface => #{interface[:name]}, type => MAC, address => #{interface[:mac_address]}, network => #{vlan}, scope => none );\n"
                end
              end
            end
            if interface[:ipv4_address]
              result+="AddAddressToInterface( device => #{device[:name]}, interface => #{interface[:name]}, type => IPv4, address => #{interface[:ipv4_address].address.to_s} );\n"
              if interface[:ipv4_network]
                result+="AddNetworkToAddress( interface => #{interface[:name]}, type => IPv4, address => #{interface[:ipv4_address].address.to_s}, network => #{interface[:ipv4_network].network.to_s}, scope => #{interface[:ipv4_network].prefix.to_s} );\n"
              end
            end
            if interface[:ipv6_address]
              result+="AddAddressToInterface( device => #{device[:name]}, interface => #{interface[:name]}, type => IPv6, address => #{interface[:ipv6_address].address.to_s} );\n"
              if interface[:ipv6_network]
                result+="AddNetworkToAddress( interface => #{interface[:name]}, type => IPv6, address => #{interface[:ipv6_address].address.to_s}, network => #{interface[:ipv6_network].network.to_s}, scope => #{interface[:ipv6_network].prefix.to_s} );\n"
              end
            end
          end
        end

        connections.each do |component,interfaces|
          interfaces.each do |interface,neighbor|
            result+="DeviceConnectionDetected( device01 => #{component.to_s}, interface01 => #{interface.to_s}, device02 => #{neighbor[0]}, interface02 => #{neighbor[1]} );\n"
          end
        end

#        ARES 2015 proof of concept implementation
#        ipmac.each do |im|
#          puts "LinkAddresses( l2address => #{im[:mac]}, l3type => IPv4, l3address => #{im[:ip]}, provenance => #{im[:provenance]}, timestamp => #{im[:timestamp]} );"
#        end

        ipmac.each do |im|
          result+="LinkAddresses( l2address => #{im[:mac]}, l3type => IPv4, l3address => #{im[:ip]});\n"
        end
        return result
      end

    end
  end
end
