#!/bin/bash
# license: gpl3 external

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# This file includes an external library and makes it accessible from
# ruby. This library has it's own license, which is accessible via the
# LICENSE symlink in this directory. The corresponding directory in the
# license hierarchy may contain further information about the library or
# it's license.
#
# The license this file and the software using this file are under, does
# not apply to the external library.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST

set -eu

APP_PATH="$(dirname $(readlink -f $0))/../"
cd "${APP_PATH}"

files="$(find . -type d \( -path ./data -o -path ./license -o -path ./doc -o -path ./log -o -path ./.git -o  -path ./src/app/data -o -path ./src/app/license -o -path ./src/app/doc -o -path ./log -o -path ./src/app/.git -o  -path ./src/local/data -o -path ./src/local/license -o -path ./src/local/doc -o -path ./src/local/log -o -path ./src/local/.git \) -prune -o -type f \( -name "*.rb" -o -name "*.sh" \) -print)"

for f in ${files}; do
  if ! grep -E "^# license: " "${f}" > /dev/null;  then
    echo "'${f}' has no license annotation"
cat <<EOF
Please chose license:
0) Defer decision
1) No license notice
2) GPL2 only
3) GPL2 or above
4) GPL3 only
5) GPL3 or above
Append the letter 'e' to your choice to add external library notice
EOF
    read -r choice
    choice_license="${choice:0:1}"
    choice_external="${choice:1:1}"
    external=""
    if [ "${choice_external}" = "e" ]; then
      external="external"
    fi
    license=""
    case "${choice_license}" in
      0)
        continue
        ;;
      1)
        license="none"
        ;;
      2)
        license="gpl2"
        ;;
      3)
        license="gpl2p"
        ;;
      4)
        license="gpl3"
        ;;
      5)
        license="gpl3p"
        ;;
      *) echo "Unknown choice ${choice}; deferring"
        continue
        ;;
    esac
    #Avoid doubled license notice in this file
    annotation="# license: ${license} ${external}\n\n### BEGIN LICENSE"
    annotation="${annotation} NOTICE\n### END LICENSE NOTICE\n\n### BEGIN AUTHOR LIST\n#\n### END AUTHOR LIST"
    t=$(mktemp 2> /dev/null)
    cp "${f}" "${t}"
    declare -i skip=0
    if head -n1 "${f}" | grep -e '^#!' > /dev/null; then
      skip=$((${skip}+1))
    fi
    if head -n2 "${f}" | grep -E '^# *encoding' > /dev/null; then
      skip=$((${skip}+1))
    fi
    if [ ${skip} -ne 0 ]; then
      head -n${skip} "${t}" > "${f}"
      echo -e "${annotation}" >> "${f}"
      tail -n+$((${skip}+1)) "${t}" >> "${f}"
    else
      echo -e "${annotation}" > "${f}"
      cat "${t}" >> "${f}"
    fi
    rm "${t}"
    echo ""
  fi
done

