#!/bin/bash
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST

set -eu

APP_PATH="$(dirname $(readlink -f $0))/../"
HEADER_PATH="$(dirname $(readlink -f $0))/../tools/licenses/"

#Avoid doubled license notice in this file
license_head="### BEGIN LICENSE"
license_head="${license_head} NOTICE"
license_tail="### END LICENSE NOTICE"

cd "${APP_PATH}"
files="$(find -name "*.sh" -o -name "*.rb")"

for f in ${files}; do
  licenses="$(grep -E "^# license: " "${f}" | sed -e 's/^# license:  *//' -e 's/  */ /' -e 's/  *$//g')"
  if [ -n "${licenses}" ]; then
    header=""
    for l in ${licenses}; do
      if [ -f "${HEADER_PATH}/header.${l}" ]; then
        if [ -z "${header}" ]; then
          header="$(<"${HEADER_PATH}/header.${l}")"
        else
          header="${header}\n\n$(<"${HEADER_PATH}/header.${l}")"
        fi
      else
        echo "No license notice for license identifier ${l}"
      fi
    done
    first="/${license_head}/{p=1;print;print \"${header}\"}/${license_tail}/{p=0}"
    second='!p'
    t=$(mktemp 2> /dev/null)
    cp "${f}" "${t}"
    awk "${first}${second}" "${t}" > "${f}"
    rm "${t}"
  fi
done

